;=============================================================================
; Papier nach Modellbereich
;
; Transformation von Elementen des Papierbereichs in den Modellbereich
; Transformationsparameter aus der Funktion #vpt_box
;
; Funktion vpt_box uebernommen von reini urban und teilweise erweitert
;
; Dipl.-Ing.(FH) Georg Koenig    gmkoenig@web.de
; AUTOCAD 2002 12.05.2003
;=============================================================================

(defun gmk_vpt_box ( $view /                        ; Ename of viewport
                     v_eed                          ; Viewport entity list including EED
                     v_psw                          ; Paper space width
                     v_psh                          ;             height
                     v_psxp                         ; layoutbereich Zentrum x 
                     v_psyp                         ; layoutbereich Zentrum y
                     v_msw                          ; Model space width
                     v_msh                          ;             height
                     v_msxp                         ;             view centre x point
                     v_msyp                         ;                         y point
                     v_ang                          ;             twist angle
                     v_xy1l                         ; links unten layout
                     v_xy2l                         ; rechts unten layout
                     v_xy3l                         ; rechts oben layout
                     v_xy4l                         ; links oben layout
                     v_xy1                          ;             left bottom point
                     v_xy2                          ;             right bottom point
                     v_xy3                          ;             right top point
                     v_xy4                          ;             left top point
                     v_scale                        ;             scale
                     #ent_gc                        ; Local function
                )
  (defun #ENT_GC ( $gc $list )                   ; Return group code from list
    (cdr (assoc $gc $list))                      ; |
  );end defun #ENT_GC                            ; |

  (defun #TRG_ROT ( $point    ; 2D point         ; Rotate point
                    $angle /  ; Angle in radians ; |
                    x y       ; x & y of $point  ; |
                    ca sa     ; cos/sin of $angle; |
                  )                              ; |
    (setq x  (car  $point)                       ; |
          y  (cadr $point)                       ; |
          ca (cos  $angle)                       ; |
          sa (sin  $angle)                       ; |
    )                                            ; |
    (list (- (* x ca) (* y sa))                  ; |
          (+ (* x sa) (* y ca))                  ; |
    )                                            ; |
  );end defun #TRG_ROT                           ; |

                                                 ; **** MAIN BODY ****
  (if (and (= 'ENAME (type $view))               ; if Ename passed and...
           (setq v_eed (entget $view '("ACAD"))) ; .. got entity list and...
           (= "VIEWPORT" (#ent_gc 0 v_eed))      ; .. is viewport
      )                                          ; |
    (progn                                       ; |
      (PRINC (#ent_gc 10 v_eed)) 
      (setq v_psw   (#ent_gc 40 v_eed)           ; |  paper space width
            v_psh   (#ent_gc 41 v_eed)           ; |  paper space height
            v_psxp  (CAR (#ent_gc 10 v_eed))     ; |  mittelpunkt x layoutbereich
            v_psyp  (CADR (#ent_gc 10 v_eed))    ; |  mittelpunkt y layoutbereich
            v_xy1l  (list (- v_psxp (/ v_psw 2)) ; |  4 Ecken des viewports im layoutbereich
                          (- v_psyp (/ v_psh 2)) ; | 
                    )                            ; |

            v_xy2l  (list (+ v_psxp (/ v_psw 2)) ; |
                          (- v_psyp (/ v_psh 2)) ; | 
                    )                            ; |
            v_xy3l  (list (+ v_psxp (/ v_psw 2)) ; |
                          (+ v_psyp (/ v_psh 2)) ; |
                    )                            ; |
            v_xy4l  (list (- v_psxp (/ v_psw 2)) ; |
                          (+ v_psyp (/ v_psh 2)) ; |
                    )                            ; |
            v_eed   (cdar (#ent_gc -3 v_eed))    ; |  extended entity data
            v_eed   (member                      ; |  discard EED before twist angle
                      (assoc 1040 v_eed) v_eed   ; |  |
                    )                            ; |  |
            v_ang   (#ent_gc 1040 v_eed)         ; |  1st gc 1040 (twist angle)
            v_eed   (cdr v_eed)                  ; |  remainder of eed
            v_msh   (#ent_gc 1040 v_eed)         ; |  2nd gc 1040 (view height)
            v_eed   (cdr v_eed)                  ; |  remainder of eed
            v_msxp  (#ent_gc 1040 v_eed)         ; |  3rd gc 1040 (view x point)
            v_eed   (cdr v_eed)                  ; |  remainder of eed
            v_msyp  (#ent_gc 1040 v_eed)         ; |  4th gc 1040 (view y point)
            v_scale (/ v_psh v_msh)              ; |  scale
            v_msw   (/ v_psw  v_scale)           ; |  ms width
            v_xy1   (list (- v_msxp (/ v_msw 2)) ; |  ms left border and ...
                          (- v_msyp (/ v_msh 2)) ; |     bottom border
                    )                            ; |
      )                                          ; |
      (setq v_ang (- (* 2 pi) v_ang)             ; |
            v_xy1 (#trg_rot v_xy1 v_ang)         ; |  1st point
            v_xy2 (polar v_xy1 v_ang v_msw)      ; |  2nd point
            v_ang (+ v_ang (/ pi 2))             ; |  turn 90 deg
            v_xy3 (polar v_xy2 v_ang v_msh)      ; |  3rd point
            v_ang (+ v_ang (/ pi 2))             ; |  turn 90 deg
            v_xy4 (polar v_xy3 v_ang v_msw)      ; |  4th point
      )                                          ; |
      (list v_xy1 v_xy2 v_xy3 v_xy4              ; |  corner points modellbereich 
            v_xy1l v_xy2l v_xy3l v_xy4l          ; |  corner points layoutbereich
            v_scale                              ; |  massstabsfaktor
            v_ang                                ; |  drehwinkel im bogenmass
      )
    );end progn                                  ; |  
  );end if                                       ; end if
);end defun #VPT_BOX



(DEFUN gmk_t_par_2ip (anfp1 endp1 anfp2 endp2                  ; transformation mit 2 identischen punkten
                      / r1a h1a                                ; eine drehung, eine verschiebung, ein massstabsfaktor 
                        r2a h2a 
                        m
                        riwi1 riwi2 drehw
                        o a r0 h0
                        erg )
(SETQ r1a (CAR anfp1)                                      ; Rechts und Hochwert der identischen Punkte
      h1a (CADR anfp1)                                     ; Transformation von System 1 nach System 2
      r2a (CAR anfp2)
      h2a (CADR anfp2)
      m (/ (DISTANCE anfp2 endp2) (DISTANCE anfp1 endp1))  ; Mastabsfaktor
      riwi1 (- (/ pi 2.0) (ANGLE anfp1 endp1))             ; Riwi System1 im Bogenmass
      riwi2 (- (/ pi 2.0) (ANGLE anfp2 endp2))             ; Riwi System2 im Bogenmass
      drehw (- riwi2 riwi1)                                ; Drehwinkel im Bogenmass
      o (* (SIN drehw) m)                                  ; Transformationsparameter
      a (* (COS drehw) m)
      r0 (- r2a (* o h1a) (* a r1a))
      h0 (+ (- h2a (* a h1a)) (* o r1a))

)
(LIST o a r0 h0 m drehw)                                   ; Ergebnis: Transformationsparameter
)



(DEFUN C:gmk_bereich ( / 
                       anfp1 endp1 anfp2 endp2   ; 2 Eckpunkte des Ansichtsfensters zur Berechnung der Transf.parameter
                       asf                       ; Auswahlsatz Ansichtsfenster
                       transpar                  ; Transformationsparameter
                       as                        ; Hilfsauswahlsatz fr den temporren Block
                     )
(SETVAR "tilemode" 0)
(SETQ asf (gmk_vpt_box (CAR (ENTSEL "Ansichtsfenster whlen:"))))                 ; Ansichtsfenster whlen
(PRINC asf) (TERPRI)
(SETQ transpar (gmk_t_par_2ip (nth 4 asf) (nth 5 asf) (nth 0 asf) (nth 1 asf)))   ; Berechnung der Transformationsparameter
(IF (TBLSEARCH "block" "gmk_pb")                                                  ; zu transformierende Elemente auswhlen 
        (PROGN (COMMAND "_-block" "gmk_pb" "j" "0,0" (SSGET)) (COMMAND ""))       ; und als Block ablegen
        (PROGN (COMMAND "_-block" "gmk_pb" "0,0" (SSGET)) (COMMAND ""))
)
(COMMAND "_-insert" "gmk_pb" "0,0" "1" "1" "0")                                   ; erstes Einfgen anstatt "hoppla"
(COMMAND "_-insert" "gmk_pb" "0,0" "1" "1" "0")                                   ; zweites Einfgen zum transformieren in den Modellb.)
(SETQ as (ENTGET (ENTLAST))                                                       ; entity-Namen des Blocks ermitteln
      as(subst (cons 10 (gmk_t_2ip transpar (CDR(ASSOC 10 as)))) (assoc 10 as)as) ; neuer Einfgepunkt fr den Modellbereich
      as(subst (cons 410 "Modell") (assoc 410 as)as)                              ; Name des Zeichenbereichs = Modellbereich
      as(subst (cons 67 0) (assoc 67 as)as)                                       ; schiebe Block in den Modellbereich
      as(subst (cons 41 (nth 4 transpar)) (assoc 41 as)as)                        ; Block skalieren in x
      as(subst (cons 42 (nth 4 transpar)) (assoc 42 as)as)                        ; Block skalieren in y
      as(subst (cons 50 (* (nth 5 transpar) -1)) (assoc 50 as)as)                 ; Block drehen
)
(entmod as)
)