VERSION 5.00
Begin VB.Form Form_druckmanager 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Druckmanager"
   ClientHeight    =   6765
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   3375
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6765
   ScaleWidth      =   3375
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton Command_programm_ende 
      Caption         =   "Programm Ende"
      Height          =   495
      Left            =   120
      TabIndex        =   21
      Top             =   6120
      Width           =   1335
   End
   Begin VB.Frame Frame_druckbereich_von 
      Caption         =   "Druckbereich"
      Height          =   1335
      Left            =   120
      TabIndex        =   17
      Top             =   4560
      Width           =   3135
      Begin VB.OptionButton Option_druckbereich_aktuelle_seite 
         Caption         =   "Aktuelle Seite"
         Height          =   315
         Left            =   120
         TabIndex        =   26
         Top             =   240
         Value           =   -1  'True
         Width           =   2175
      End
      Begin VB.OptionButton Option_druckbereich_seite_von_bis 
         Caption         =   "Seite von:"
         Height          =   255
         Left            =   120
         TabIndex        =   25
         Top             =   600
         Width           =   1095
      End
      Begin VB.OptionButton Option_druckbereich_auswahl 
         Caption         =   "Auswahl"
         Height          =   255
         Left            =   120
         TabIndex        =   24
         Top             =   960
         Width           =   2175
      End
      Begin VB.TextBox Text_druckbereich_bis 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   2280
         MaxLength       =   3
         TabIndex        =   20
         Top             =   600
         Width           =   495
      End
      Begin VB.TextBox Text_druckbereich_von 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   1
         EndProperty
         Height          =   285
         Left            =   1200
         MaxLength       =   3
         TabIndex        =   18
         Top             =   588
         Width           =   495
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "V1"
         Height          =   192
         Left            =   2640
         TabIndex        =   27
         Top             =   960
         Width           =   192
      End
      Begin VB.Label Label1 
         Caption         =   "bis:"
         Height          =   255
         Index           =   1
         Left            =   1920
         TabIndex        =   19
         Top             =   600
         Width           =   255
      End
   End
   Begin VB.Frame Frame5 
      Caption         =   "SW-Dokument"
      Height          =   615
      Left            =   120
      TabIndex        =   15
      Top             =   120
      Width           =   3135
      Begin VB.Label Label_SW_Format 
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   240
         Width           =   2895
      End
   End
   Begin VB.CommandButton Command_drucken 
      Caption         =   "Drucken"
      Height          =   495
      Left            =   1920
      TabIndex        =   9
      Top             =   6120
      Width           =   1335
   End
   Begin VB.Frame Frame4 
      Caption         =   "Papierformat"
      Height          =   2055
      Left            =   120
      TabIndex        =   8
      Top             =   2280
      Width           =   1335
      Begin VB.OptionButton Option_papierformat_A0 
         Caption         =   "A0"
         Height          =   255
         Left            =   120
         TabIndex        =   14
         Top             =   1680
         Width           =   975
      End
      Begin VB.OptionButton Option_papierformat_A1 
         Caption         =   "A1"
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   1320
         Width           =   975
      End
      Begin VB.OptionButton Option_papierformat_A2 
         Caption         =   "A2"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   960
         Width           =   975
      End
      Begin VB.OptionButton Option_papierformat_A3 
         Caption         =   "A3"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   600
         Width           =   975
      End
      Begin VB.OptionButton Option_papierformat_A4 
         Caption         =   "A4"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   240
         Value           =   -1  'True
         Width           =   975
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Druckerauswahl"
      Height          =   1095
      Left            =   120
      TabIndex        =   6
      Top             =   960
      Width           =   3135
      Begin VB.ComboBox Combo_druckerauswahl 
         Height          =   315
         Left            =   120
         Sorted          =   -1  'True
         TabIndex        =   7
         Top             =   360
         Width           =   2895
      End
      Begin VB.Label Label_drucker_standort 
         Height          =   255
         Left            =   840
         TabIndex        =   23
         Top             =   720
         Width           =   2175
      End
      Begin VB.Label Label2 
         Caption         =   "Standort:"
         Height          =   255
         Left            =   120
         TabIndex        =   22
         Top             =   720
         Width           =   735
      End
   End
   Begin VB.Frame Frame_skalieren 
      Caption         =   "Skalieren"
      Height          =   975
      Left            =   1800
      TabIndex        =   3
      Top             =   3360
      Width           =   1455
      Begin VB.OptionButton Option_skalieren_eins_zu_eins 
         Caption         =   "1:1"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   240
         Value           =   -1  'True
         Width           =   1095
      End
      Begin VB.OptionButton Option_skalieren_einpassen 
         Caption         =   "Einpassen"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         Top             =   600
         Width           =   1095
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Format"
      Height          =   975
      Left            =   1800
      TabIndex        =   0
      Top             =   2280
      Width           =   1455
      Begin VB.OptionButton Option_format_quer 
         Caption         =   "Querformat"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   600
         Width           =   1215
      End
      Begin VB.OptionButton Option_format_hoch 
         Caption         =   "Hochformat"
         Height          =   255
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Value           =   -1  'True
         Width           =   1215
      End
   End
End
Attribute VB_Name = "Form_druckmanager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Speicherplatz reservieren
Const vbPRORPortrait = 1
Const vbPRORLandscape = 2

Const swPrintPaperSize = 0
Const swPrintOrientation = 1
Const swDocDRAWING = 3

Dim vbPRPSA0 As Integer
Dim vbPRPSA1 As Integer
Dim vbPRPSA2 As Integer
Dim vbPRPSA3 As Integer
Dim vbPRPSA4 As Integer

Dim sw_papier_groesse As String
Dim sw_papier_ausrichtung As String
Dim collectionDruckerDaten As Collection

Const DC_PAPERS = 2
Const DC_PAPERNAMES = 16

Dim swApp As Object
Dim ModelDoc As Object

Dim aktiver_Drucker As String
Dim aktives_Document_zeichnung As Boolean

Private Declare Function DeviceCapabilities Lib "winspool.drv" _
        Alias "DeviceCapabilitiesA" (ByVal lpDeviceName As _
        String, ByVal lpPort As String, ByVal iIndex As Long, _
        lpOutput As Any, ByVal dev As Long) As Long
Private Sub Combo_druckerauswahl_Change()
    'Zum vernderten Drucker die verfgbaren Papiergrssen ermitteln
    Dim drucker_in_druckerliste As Boolean
    drucker_in_druckerliste = False
         
    For i = 1 To collectionDruckerDaten.Count
        If Combo_druckerauswahl.text = collectionDruckerDaten.Item(i).Get_drucker_info Then
            papiergroessen_ermitteln ("\\" + collectionDruckerDaten.Item(i).Get_print_server + "\" + collectionDruckerDaten.Item(i).Get_drucker_name)
            aktiver_Drucker = "\\" + collectionDruckerDaten.Item(i).Get_print_server + "\" + collectionDruckerDaten.Item(i).Get_drucker_name
            Label_drucker_standort.Caption = collectionDruckerDaten.Item(i).Get_drucker_standort
            drucker_in_druckerliste = True
        End If
    Next i
    
    'Wenn der Druckername nicht in der Liste steht, wird der Name genommen der im Combo Feld steht genommen
    If drucker_in_druckerliste = False Then
        papiergroessen_ermitteln (Combo_druckerauswahl.text)
        Label_drucker_standort.Caption = "Unbekannt"
    End If
End Sub
Private Sub Combo_druckerauswahl_Click()
    'Zum vernderten Drucker die verfgbaren Papiergrssen ermitteln
    Dim drucker_in_druckerliste As Boolean
    drucker_in_druckerliste = False
         
    For i = 1 To collectionDruckerDaten.Count
        If Combo_druckerauswahl.text = collectionDruckerDaten.Item(i).Get_drucker_info Then
            papiergroessen_ermitteln ("\\" + collectionDruckerDaten.Item(i).Get_print_server + "\" + collectionDruckerDaten.Item(i).Get_drucker_name)
            aktiver_Drucker = "\\" + collectionDruckerDaten.Item(i).Get_print_server + "\" + collectionDruckerDaten.Item(i).Get_drucker_name
            Label_drucker_standort.Caption = collectionDruckerDaten.Item(i).Get_drucker_standort
            drucker_in_druckerliste = True
        End If
    Next i
    
    'Wenn der Druckername nicht in der Liste steht, wird der Name genommen der im Combo Feld steht genommen
    If drucker_in_druckerliste = False Then
        papiergroessen_ermitteln (Combo_druckerauswahl.text)
        Label_drucker_standort.Caption = "Unbekannt"
    End If
End Sub
Private Sub Command_drucken_Click()
    'Speicherplatz reservieren
    Dim Start_Seite As Integer
    Dim End_Seite As Integer
    Dim Anzahl_Kopien As Integer
    Dim Massstab As Integer
    Dim swApp As Object
    Dim Part As Object
    
    
    'Startwerte festlegen
    Start_Seite = 1
    End_Seite = 1
    Anzahl_Kopien = 1
    
    Set swApp = CreateObject("SldWorks.Application")
    Set Part = swApp.ActiveDoc
    
    'Den aktiven Drucker auswhlen
    swApp.ActivePrinter = aktiver_Drucker
    
    'Das Format einstellen
    If Option_format_hoch.Value = True Then
        Part.PrintSetup(swPrintOrientation) = vbPRORPortrait
    End If
    If Option_format_quer.Value = True Then
        Part.PrintSetup(swPrintOrientation) = vbPRORLandscape
    End If
    
    'Die Skalierung einstellen
    If Option_skalieren_eins_zu_eins.Value = True Then
        Massstab = 1#
    End If
    If Option_skalieren_einpassen.Value = True Then
        Massstab = 0#
    End If
    
    'Das Papierformat einstellen
    If Option_papierformat_A4.Value = True Then
        'Auf A4 stellen
        ModelDoc.PrintSetup(swPrintPaperSize) = vbPRPSA4
    End If
    If Option_papierformat_A3.Value = True Then
        'Auf A3 stellen
        ModelDoc.PrintSetup(swPrintPaperSize) = vbPRPSA3
    End If
    If Option_papierformat_A2.Value = True Then
        'Auf A2 stellen
        ModelDoc.PrintSetup(swPrintPaperSize) = vbPRPSA2
    End If
    If Option_papierformat_A1.Value = True Then
        'Auf A1 stellen
        ModelDoc.PrintSetup(swPrintPaperSize) = vbPRPSA1
    End If
    If Option_papierformat_A0.Value = True Then
        'Auf A0 stellen
        ModelDoc.PrintSetup(swPrintPaperSize) = vbPRPSA0
    End If
    
    'Die Seitennummer ermitteln die gedruckt werden soll
    If aktives_Document_zeichnung <> False Then
        If Option_druckbereich_aktuelle_seite.Value = True Then
            Start_Seite = zu_druckende_seite_ermitteln
            End_Seite = Start_Seite
        End If
        If Option_druckbereich_seite_von_bis.Value = True Then
            If Text_druckbereich_von.text = "" Then
                Start_Seite = 1
            Else
                Start_Seite = Text_druckbereich_von.text
            End If
            If Text_druckbereich_bis.text = "" Then
                End_Seite = ModelDoc.GetSheetCount
            Else
                End_Seite = Text_druckbereich_bis.text
            End If
        End If
    End If
        
    'Fals eine Auswahl gedruckt werden soll, so wird hier weitergemacht
    If Option_druckbereich_auswahl.Value = True Then
        DoEvents
                   
        'SW aktivieren
        AppActivate "SolidWorks 2005", True
       
        'Datei
        SendKeys "%{D}", True
       
        'Drucken
        SendKeys "D", True
            
        'Enter
        SendKeys "{ENTER}", True
       
        'Auswahl
        SendKeys "A", True
        SendKeys "A", True
            
        'Space
        SendKeys " ", True
            
        'Enter
        SendKeys "{ENTER}", True
        End
    End If
    
    'Den Ausdruck starten
    Part.PrintOut2 Start_Seite, End_Seite, Anzahl_Kopien, False, aktiver_Drucker, Massstab, False, ""
    
    'Das Programm beenden
    'MsgBox "Der Ausdruck wurde gestartet."
    End
End Sub
Private Function zu_druckende_seite_ermitteln() As Integer
    'Speicherplatz reservieren
    Dim pSheet As Object
    Dim pView As Object
    Dim pos As Integer
     
    'Den Namen des aktuellen Sheet ermitteln
    Set pView = ModelDoc.GetFirstView
    view_name = pView.Name
    
    'Eine Liste aller Sheets erzeugen
    all_view_names = ModelDoc.GetSheetNames
    
    'Die Zeichenblattnummer ermitteln
    For i = 0 To ModelDoc.GetSheetCount - 1
        pos = pos + 1
        If view_name = all_view_names(i) Then
            Exit For
        End If
    Next i
    
    zu_druckende_seite_ermitteln = pos
End Function
Sub papiergroessen_ermitteln(druckername As String)
    'Die Papiergrssen ermitteln, die der Drucker untersttzt
    
    'Speicherplatz reservieren
    Dim Papers%, PaperList$
    Dim PSize$
    Dim PaperNums%()
    
    'Alle Papierformate deaktivieren
    Option_papierformat_A4.Enabled = False
    Option_papierformat_A3.Enabled = False
    Option_papierformat_A2.Enabled = False
    Option_papierformat_A1.Enabled = False
    Option_papierformat_A0.Enabled = False
        
    'Den Druckerindex ermitteln
    drucker_index = ermittel_drucker_index(druckername)
    
    'Drucker zum Standarddrucker machen
    Set Printer = Printers(drucker_index)
            
    'Die Anzahl der untersttzten Papiergrssen ermitteln
    Papers = DeviceCapabilities(Printer.DeviceName, Printer.Port, DC_PAPERS, ByVal vbNullString, 0)
    
    'Wenn es mehr als 0 Papiersorten gibt
    If Papers > 0 Then
        ReDim PaperNums(1 To Papers)
      
        'In PaperNums werden die Papierkonstanten gespeichert
        Papers = DeviceCapabilities(Printer.DeviceName, Printer.Port, DC_PAPERS, PaperNums(1), 0)
      
        'Die Liste mit 0 vorbelegen
        PaperList = String$(64 * Papers, 0)
      
        'In PaperList werden die Namen der Papiersorten gespeichert
        Papers = DeviceCapabilities(Printer.DeviceName, Printer.Port, DC_PAPERNAMES, ByVal PaperList, 0)
  
        'Durch alle verfgbaren Papiergrssen laufen
        For i = 1 To Papers
            'Den Namen des Papiers ermitteln
            Papier_Name = Mid(PaperList, 64 * (i - 1) + 1, 64)
            
            'Die Lnge des Namen ermitteln
            Laenge_Papier_name = InStr(Mid(PaperList, 64 * (i - 1) + 1, 64), vbNullChar)
            
            'Den Namen des Papiers herausfiltern
            If Laenge_Papier_name > 0 Then
                 Papier_Name = Left$(Papier_Name, Laenge_Papier_name - 1)
            End If
                   
            'Die Papierkonstante abspeichern
            Dim Papier_konstante As String
            Papier_konstante = PaperNums(i)
        
            'Zur jeweiligen Papiergrsse die Papierkonstante abspeichern
            If InStr(1, Papier_Name, "A4", vbTextCompare) And Len(Papier_Name) = 2 Then
                vbPRPSA4 = Papier_konstante
                Option_papierformat_A4.Enabled = True
            End If
            If InStr(1, Papier_Name, "A3", vbTextCompare) And Len(Papier_Name) = 2 Then
                vbPRPSA3 = Papier_konstante
                Option_papierformat_A3.Enabled = True
            End If
            If InStr(1, Papier_Name, "A2", vbTextCompare) And Len(Papier_Name) = 2 Then
                vbPRPSA2 = Papier_konstante
                Option_papierformat_A2.Enabled = True
            End If
            If InStr(1, Papier_Name, "A1", vbTextCompare) And Len(Papier_Name) = 2 Then
                vbPRPSA1 = Papier_konstante
                Option_papierformat_A1.Enabled = True
            End If
            If InStr(1, Papier_Name, "A0", vbTextCompare) And Len(Papier_Name) = 2 Then
                vbPRPSA0 = Papier_konstante
                Option_papierformat_A0.Enabled = True
            End If
        Next i
    End If
    
    'Das richtige Papierformat anwhlen
    If Option_papierformat_A0.Enabled = True Then
        Option_papierformat_A0.Value = True
    End If
    If Option_papierformat_A1.Enabled = True Then
        Option_papierformat_A1.Value = True
    End If
    If Option_papierformat_A2.Enabled = True Then
        Option_papierformat_A2.Value = True
    End If
    If Option_papierformat_A3.Enabled = True Then
        Option_papierformat_A3.Value = True
    End If
    If Option_papierformat_A4.Enabled = True Then
        Option_papierformat_A4.Value = True
    End If
End Sub
Function ermittel_drucker_index(druckername As String) As Integer
    'Aus dem Druckernamen den Index ermitteln
    For i = 0 To Printers.Count - 1
        If InStr(1, druckername, Printers(i).DeviceName, vbTextCompare) Then
            ermittel_drucker_index = i
            Exit Function
        End If
    Next i
End Function

Private Sub Command_programm_ende_Click()
    'Das Programm beenden
    End
End Sub
Private Sub Form_KeyPress(KeyAscii As Integer)
    'Auf das Tastaurereigniss reagieren
    If KeyAscii = 27 Then
        Command_programm_ende_Click
    End If
End Sub

Private Sub Form_Load()
    Form_druckmanager.Show
    
    'Alle System_Drucker in der Collection abspeichern
    Dim System_Drucker As Printer
    aktives_Document_zeichnung = True
   
    'Die Druckerdatei einlesen
    lese_druckerdatei_ein
    
    'Die Druckernamen in die Auswahlliste eintragen
    druckernamen_eintragen
    
    'Objecte erzeugen
    If objecte_erzeugen = False Then
        End
    End If
    
    'SW Parameter ermitteln
    ermittle_SW_parameter
    
    'Den fr den Druckjob besten Drucker ermitteln
    besten_drucker_ermitteln
                    
    'Fehlerbehandlung aktivieren
    On Error GoTo Fehlerbehandlung
     
    'Die Anzahl der Seiten eintragen
    Text_druckbereich_bis.text = ModelDoc.GetSheetCount
    Text_druckbereich_von.text = 1
        
    'Den Druckbereich auf die aktuelle Seite einstellen
    Option_druckbereich_aktuelle_seite.Value = True
        
    Exit Sub
    
Fehlerbehandlung:
    'Die Fehlerbehandlung deaktivieren
    On Error GoTo 0
End Sub
Sub druckernamen_eintragen()
    'Die Druckernamen in die Liste eintragen
    Dim drucker_in_druckerliste As Boolean
    drucker_in_druckerliste = False
        
    For i = 0 To Printers.Count - 1
        For j = 0 To collectionDruckerDaten.Count - 1
            If (Printers(i).DeviceName = ("\\" + collectionDruckerDaten.Item(j + 1).Get_print_server + "\" + collectionDruckerDaten.Item(j + 1).Get_drucker_name)) Or (Printers(i).DeviceName = ("\\" + UCase(collectionDruckerDaten.Item(j + 1).Get_print_server) + "\" + collectionDruckerDaten.Item(j + 1).Get_drucker_name)) Then
                Combo_druckerauswahl.AddItem (collectionDruckerDaten.Item(j + 1).Get_drucker_info)
                drucker_in_druckerliste = True
                Exit For
            End If
        Next j
        If drucker_in_druckerliste = False Then
            Combo_druckerauswahl.AddItem (Printers(i).DeviceName)
        End If
        drucker_in_druckerliste = False
    Next i
End Sub
Private Function ermittle_SW_parameter() As Boolean
    'Die Parameter des SW Dokuments ermitteln
    
    'Prfen ob es sich bei dem Dokument um ein Drawing handelt
    If ModelDoc.GetType <> swDocDRAWING Then
        ermittle_SW_parameter = False
        Exit Function
    End If

    'Pointer auf den aktuellen Shett holen
    Set pSheet = ModelDoc.GetCurrentSheet
    
    'Die Eigenschaften des Sheets auslesen
    sheet_eigenschaften = pSheet.GetProperties
    
    'Das Blattformat der Zeichnung auslesen
    blatt_format = sheet_eigenschaften(0)
    
    'Den passenden Text anzeigen
    Select Case (blatt_format)
        Case 6: Label_SW_Format.Caption = "A4 - Querformat": sw_papier_groesse = "A4": sw_papier_ausrichtung = "quer"
        Case 7: Label_SW_Format.Caption = "A4 - Hochformat": sw_papier_groesse = "A4": sw_papier_ausrichtung = "hoch"
        Case 8: Label_SW_Format.Caption = "A3 - Querformat": sw_papier_groesse = "A3": sw_papier_ausrichtung = "quer"
        Case 9: Label_SW_Format.Caption = "A2 - Querformat": sw_papier_groesse = "A2": sw_papier_ausrichtung = "quer"
        Case 10: Label_SW_Format.Caption = "A1 - Querformat": sw_papier_groesse = "A1": sw_papier_ausrichtung = "quer"
        Case 11: Label_SW_Format.Caption = "A0 - Querformat": sw_papier_groesse = "A0": sw_papier_ausrichtung = "quer"
    End Select
        
    'Wenn kein passendes Blattformat vorliegt wird false zurckgegeben
    If blatt_format < 6 Or blatt_format > 11 Then
        Label_SW_Format.Caption = "Kein standard DIN Format."
        ermittle_SW_parameter = False
        Exit Function
    End If
    
    ermittle_SW_parameter = True
End Function
Private Function objecte_erzeugen() As Boolean
    'Poniter auf SW erzeugen
    Set swApp = CreateObject("SldWorks.Application")
    
    'Pointer auf das Active Document erzeugen
    Set ModelDoc = swApp.ActiveDoc

    'Prfen ob ein Document geladen ist
    If ModelDoc Is Nothing Then
        MsgBox "Es ist kein Dokument geladen."
        objecte_erzeugen = False
        Exit Function
    End If
    
    'Wenn es sich bei dem aktiven Document nicht um ein eine Zeichnung handelt, so wird hier weitergemacht
    If ModelDoc.GetType() <> 3 Then
        Option_druckbereich_seite_von_bis.Enabled = False
        Text_druckbereich_von.Enabled = False
        Text_druckbereich_bis.Enabled = False
        Option_druckbereich_auswahl.Enabled = False
        
        aktives_Document_zeichnung = False
    End If
    
    'Wenn alles geklappt hat True zurckgeben
    objecte_erzeugen = True
End Function

Private Sub Option_druckbereich_aktuelle_seite_Click()
    'Die Skalierung aktivieren
    Frame_skalieren.Enabled = True
    Option_skalieren_eins_zu_eins.Enabled = True
    Option_skalieren_einpassen.Enabled = True
End Sub
Private Sub Option_druckbereich_auswahl_Click()
    'Die Skalierung deaktivieren
    Frame_skalieren.Enabled = False
    Option_skalieren_eins_zu_eins.Enabled = False
    Option_skalieren_einpassen.Enabled = False
End Sub
Private Sub Option_druckbereich_seite_von_bis_Click()
    'Die Skalierung aktivieren
    Frame_skalieren.Enabled = True
    Option_skalieren_eins_zu_eins.Enabled = True
    Option_skalieren_einpassen.Enabled = True
End Sub
Private Sub Text_druckbereich_bis_Change()
    'Wenn die Seitenzahl verndert wurde, so wird die Makierung gendert
    Option_druckbereich_seite_von_bis.Value = True
    Option_druckbereich_aktuelle_seite.Value = False
    
    'Prfen, ob die Eingabe stimmt
    laenge = Len(Text_druckbereich_bis.text)
    For i = 1 To laenge
        asc_wert = Asc(Mid(Text_druckbereich_bis.text, i, 1))

        If asc_wert < 48 Or asc_wert > 57 Then
            Text_druckbereich_bis.text = ModelDoc.GetSheetCount
            Text_druckbereich_bis.SelStart = Len(Text_druckbereich_bis.text)
            Exit Sub
        End If
    Next i
    
    'Fehlerbehandlung aktivieren
    On Error GoTo Fehlerbehandlung
   
    Dim zahl As Integer
    zahl = Text_druckbereich_bis.text
    If zahl > ModelDoc.GetSheetCount Then
        Text_druckbereich_bis.text = ModelDoc.GetSheetCount
        Text_druckbereich_bis.SelStart = Len(Text_druckbereich_bis.text)
    End If
    
    'Fehlerbehandlung deaktivieren
    On Error GoTo 0
    Exit Sub
    
Fehlerbehandlung:
    On Error GoTo 0
End Sub
Private Sub Text_druckbereich_von_Change()
    'Wenn die Seitenzahl verndert wurde, so wird die Makierung gendert
    Option_druckbereich_seite_von_bis.Value = True
    Option_druckbereich_aktuelle_seite.Value = False
    
    'Prfen, ob die Eingabe stimmt
    laenge = Len(Text_druckbereich_von.text)
    For i = 1 To laenge
        asc_wert = Asc(Mid(Text_druckbereich_von.text, i, 1))

        If asc_wert < 48 Or asc_wert > 57 Then
            Text_druckbereich_von.text = 1
            Text_druckbereich_von.SelStart = Len(Text_druckbereich_von.text)
            Exit Sub
        End If
    Next i
    
    'Fehlerbehandlung aktivieren
    On Error GoTo Fehlerbehandlung
    
    Dim zahl As Integer
    zahl = Text_druckbereich_von.text
    If zahl > ModelDoc.GetSheetCount Then
        Text_druckbereich_von.text = 1
        Text_druckbereich_von.SelStart = Len(Text_druckbereich_von.text)
    End If
    
    'Fehlerbehandlung deaktivieren
    On Error GoTo 0
    Exit Sub
    
Fehlerbehandlung:
    On Error GoTo 0
End Sub
Private Sub lese_druckerdatei_ein()
    'Die Druckerdatei einlesen um zu ermitteln welcher Drucker geeignet ist
    
    'Speicherplatz reservieren
    Dim datei_nr As Integer
    Dim anzahl_zeilen As Integer
    Dim daten As String
    Dim abbruch As Boolean
        
    'Objecte erzeugen
    Set cdruckerdaten = New drucker_daten
    Set collectionDruckerDaten = New Collection
    
    'Startwerte festlegen
    anzahl_zeilen = 0
    druckerdatei = "drucker.txt"
    datei_nr = FreeFile

    'Fehlerbehandlungsroutine definieren
    On Error GoTo Fehlerbehandlung
    
    'Die Anzal der Zeilen in der Druckerdatei ermitteln
    Open (App.Path + "\" + druckerdatei) For Input As datei_nr
    While Not EOF(datei_nr)
        Line Input #datei_nr, tmp
        If Len(tmp) > 0 Then
            anzahl_zeilen = anzahl_zeilen + 1
        End If
    Wend
    Close #datei_nr
                    
    'Die Druckerdaten einlesen
    Open (App.Path + "\" + druckerdatei) For Input As datei_nr
    For i = 1 To anzahl_zeilen
        
        'Druckerdaten lschen und die erste Zeile der Datei einlesen
        daten = ""
        Line Input #datei_nr, daten
        
        'Die Startwerte setzen
        spalte = 1
        start_pos = 1
        end_pos = 1
        abbruch = False
        
        'Als erstes alle Papierformate verbieten
        cdruckerdaten.Set_papierformat_A4 (False)
        cdruckerdaten.Set_papierformat_A3 (False)
        cdruckerdaten.Set_papierformat_A2 (False)
        cdruckerdaten.Set_papierformat_A1 (False)
        cdruckerdaten.Set_papierformat_A0 (False)
        
        'Die Daten auslesen und in das Object eintragen
        For j = 1 To Len(daten)
            If Mid$(daten, end_pos, 1) = ";" Then
                Select Case (spalte)
                    'Wenn der Drucker der in der Druckerdatei aufgefhrt ist lokal nicht installiert ist, so wird er nicht mit in die Collectio aufgenommen
                    Case 1: cdruckerdaten.Set_print_server (Mid$(daten, start_pos, end_pos - start_pos - 1))
                    
                    Case 2: For k = 0 To Printers.Count - 1
                                       
                                If (Printers(k).DeviceName = "\\" + cdruckerdaten.Get_print_server + "\" + Mid$(daten, start_pos, end_pos - start_pos - 1)) Or (Printers(k).DeviceName = "\\" + UCase(cdruckerdaten.Get_print_server) + "\" + Mid$(daten, start_pos, end_pos - start_pos - 1)) Then
                                    cdruckerdaten.Set_drucker_name (Mid$(daten, start_pos, end_pos - start_pos - 1))
                                    abbruch = False
                                    Exit For
                                Else
                                    abbruch = True
                                End If
                            Next k
                    Case 3: cdruckerdaten.Set_drucker_info (Mid$(daten, start_pos, end_pos - start_pos - 1))
                    Case 4: cdruckerdaten.Set_drucker_standort (Mid$(daten, start_pos, end_pos - start_pos - 1))
                End Select
                If abbruch = True Then Exit For
                
                If spalte > 4 Then
                    If (Mid$(daten, start_pos, end_pos - start_pos - 1)) = "A4" Then
                        cdruckerdaten.Set_papierformat_A4 (True)
                    End If
                    If (Mid$(daten, start_pos, end_pos - start_pos - 1)) = "A3" Then
                        cdruckerdaten.Set_papierformat_A3 (True)
                    End If
                    If (Mid$(daten, start_pos, end_pos - start_pos - 1)) = "A2" Then
                        cdruckerdaten.Set_papierformat_A2 (True)
                    End If
                    If (Mid$(daten, start_pos, end_pos - start_pos - 1)) = "A1" Then
                        cdruckerdaten.Set_papierformat_A1 (True)
                    End If
                    If (Mid$(daten, start_pos, end_pos - start_pos - 1)) = "A0" Then
                        cdruckerdaten.Set_papierformat_A0 (True)
                    End If
                End If
                spalte = spalte + 1
                start_pos = end_pos + 2
            End If
            end_pos = end_pos + 1
        Next j
        
        If abbruch = False Then
            'Daten in die Collection eintragen
            collectionDruckerDaten.Add cdruckerdaten
    
            'Ein neues Drucker Objekt erzeugen
            Set cdruckerdaten = Nothing
            Set cdruckerdaten = New drucker_daten
        End If
    Next i
    Close #datei_nr

    'Die Fehlerbehandlung deaktivieren
    On Error GoTo 0
                
    Exit Sub
        
'Hier wird die Fehlerbehandlung ausgefhrt
Fehlerbehandlung:
    If Err.Number = 53 Then
        MsgBox "Datei " + App.Path + "\" + druckerdatei + " wurde nicht gefunden."
    Else
        MsgBox "Es ist ein unbekannter Fehler aufgetreten."
    End If
    
    'Die Fehlerbehandlung deaktivieren
    On Error GoTo 0
End Sub
Private Sub besten_drucker_ermitteln()
    'Den fr diesen Druckjob besten Drucker ermitteln

    If sw_papier_groesse = "A0" Then
        For i = 1 To collectionDruckerDaten.Count
            If collectionDruckerDaten.Item(i).Get_papierformat_A0 = True Then
                Combo_druckerauswahl.text = collectionDruckerDaten.Item(i).Get_drucker_info
                
                If sw_papier_ausrichtung = "quer" Then
                    Option_format_quer.Value = True
                ElseIf sw_papier_ausrichtung = "hoch" Then
                    Option_format_hoch.Value = True
                End If
                Option_papierformat_A0.Value = True
                Exit Sub
            End If
        Next i
    End If
    
    If sw_papier_groesse = "A1" Then
        For i = 1 To collectionDruckerDaten.Count
            If collectionDruckerDaten.Item(i).Get_papierformat_A1 = True Then
                Combo_druckerauswahl.text = collectionDruckerDaten.Item(i).Get_drucker_info
                
                If sw_papier_ausrichtung = "quer" Then
                    Option_format_quer.Value = True
                ElseIf sw_papier_ausrichtung = "hoch" Then
                    Option_format_hoch.Value = True
                End If
                Option_papierformat_A1.Value = True
                Exit Sub
            End If
        Next i
    End If

    If sw_papier_groesse = "A2" Then
        For i = 1 To collectionDruckerDaten.Count
            If collectionDruckerDaten.Item(i).Get_papierformat_A2 = True Then
                Combo_druckerauswahl.text = collectionDruckerDaten.Item(i).Get_drucker_info
                
                If sw_papier_ausrichtung = "quer" Then
                    Option_format_quer.Value = True
                ElseIf sw_papier_ausrichtung = "hoch" Then
                    Option_format_hoch.Value = True
                End If
                Option_papierformat_A2.Value = True
                Exit Sub
            End If
        Next i
    End If

    If sw_papier_groesse = "A3" Then
        For i = 1 To collectionDruckerDaten.Count
            If collectionDruckerDaten.Item(i).Get_papierformat_A3 = True Then
                Combo_druckerauswahl.text = collectionDruckerDaten.Item(i).Get_drucker_info
                
                If sw_papier_ausrichtung = "quer" Then
                    Option_format_quer.Value = True
                ElseIf sw_papier_ausrichtung = "hoch" Then
                    Option_format_hoch.Value = True
                End If
                Option_papierformat_A3.Value = True
                Exit Sub
             End If
        Next i
    End If

    If sw_papier_groesse = "A4" Then
        For i = 1 To collectionDruckerDaten.Count
            If collectionDruckerDaten.Item(i).Get_papierformat_A4 = True Then
                Combo_druckerauswahl.text = collectionDruckerDaten.Item(i).Get_drucker_info
        
                If sw_papier_ausrichtung = "quer" Then
                    Option_format_quer.Value = True
                ElseIf sw_papier_ausrichtung = "hoch" Then
                    Option_format_hoch.Value = True
                End If
                Option_papierformat_A4.Value = True
                Exit Sub
            End If
        Next i
    End If
    
    MsgBox "Es konnte kein optimaler Drucker gefunden werden, bitte whlen Sie selber einen Drucker aus."
End Sub
Private Sub warten()
    'Eine kleine Warteschleife um auf SW zu warten
    Dim sekunden As Variant
    
    sekunden = Timer
    sekunden = sekunden + 2
    
    Do
       DoEvents
    Loop Until (Timer >= sekunden)
End Sub
