VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Match ASM and Part Colors"
   ClientHeight    =   1080
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6855
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1080
   ScaleWidth      =   6855
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdHelp 
      Caption         =   "Help"
      Height          =   375
      Left            =   5115
      TabIndex        =   5
      Top             =   180
      Width           =   780
   End
   Begin MSComctlLib.ProgressBar pb 
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   720
      Width           =   6645
      _ExtentX        =   11721
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Exit"
      Height          =   375
      Left            =   6015
      TabIndex        =   1
      Top             =   180
      Width           =   780
   End
   Begin VB.CommandButton cmdAccept 
      Caption         =   "Process"
      Height          =   375
      Left            =   4215
      TabIndex        =   0
      Top             =   180
      Width           =   780
   End
   Begin VB.Label lblVista 
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   3960
   End
   Begin VB.Label lblPieza 
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   480
      Width           =   3960
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' revisions
'
' original version
' 15Jul2003
' Julian Guillo
' Technical Manager
' Pixel Sistemas, S.L.
' Spain

'-------------------------------------------------------------------------------

' 26Jul2003
' I took the wonderful program that Julian wrote and did the following:
' a. Added the ability to select on which drawing views the program will work.
' b. Fixed an abort on detail views.
' c. Fixed an abort on missing files in the drawing view assembly.
' d. Added code to the cancel button.
' e. Added working indicator to the first two steps of the program.

' Zohar Mills Levin
' Israel

'-----------------------------------------------------------------------------------

' 30Oct2003
' use Refresh at end of macro instead of Fit
' if assembly style is not defined, use part body style if defined
' add help

' Philip Bauman
' USA

Dim objSE As SolidEdgeFramework.Application
Dim objDraft As SolidEdgeDraft.DraftDocument
Dim objAsm As SolidEdgeAssembly.AssemblyDocument
Dim objdrv As DrawingView
Dim visibleST As String, hiddenST As String, tangentST As String
Dim RecCount As Integer
Dim found As Boolean

Private Sub cmdHelp_Click()
  frmAbout.Show vbModal, Me
  WindowToTop frmAbout.hwnd
End Sub

'--------------------------------------------------------------
'Load the form. Get SE object and check the correct environment
'--------------------------------------------------------------
Private Sub Form_Load()
On Error Resume Next
    Set objSE = GetObject(, "solidedge.application")
    Set objDraft = objSE.ActiveDocument
    If Err Then
        MsgBox "A SE Draft file from an ASM must be open"
        my_end
    End If
    If objDraft.ActiveSheet.DrawingViews.count = 0 Then
        MsgBox "There are no Drawing Views in this Sheet. Exiting."
        my_end
    End If
    found = False 'Initialise to false. To find original linear styles in the views.
    lblVista.Caption = "Select Drawing Views to update"
    RecCount = 0
    WindowToTop Me.hwnd
    WindowNotToTop Me.hwnd
End Sub

'---------------------------------------------------------------
'Cancel button. Process views in the Active Sheet.
'---------------------------------------------------------------
Private Sub cmdCancel_Click()
    my_end
End Sub

'---------------------------------------------------------------
'Accept button. Process views in the Active Sheet.
'---------------------------------------------------------------
Private Sub cmdAccept_Click()
Dim ml As ModelLink
Dim obj As Object
Dim n As Integer, i As Integer, j As Integer, k As Integer, total As Integer
Dim Selected As Boolean, objSelect As SelectSet
    'Call Form_Load
On Error Resume Next
    
    lblVista.Caption = "Working"
    Selected = True
    Set objSelect = objSE.ActiveDocument.SelectSet
    If objSelect.count = 0 Then
        Selected = False
        For n = 1 To objDraft.ActiveSheet.DrawingViews.count
            Call objSelect.Add(objDraft.ActiveSheet.DrawingViews(n))
        Next n
    End If
        
    objSE.DisplayAlerts = False
    objSE.DelayCompute = True

'    total = 0
'    For Each obj In objSE.ActiveDocument.SelectSet
'        If obj.Type = igDrawingView Then
'            If (obj.DrawingViewType <> igDetailView) And (obj.DrawingViewType <> igNullView) Then
'                total = total + 1
'            End If
'        Else
'            objSE.ActiveDocument.SelectSet.Remove
'
'        End If
'    Next

    'Process the selected objects. Get rid of those different to drawing views.
    For i = objSelect.count To 1 Step -1
        If objSelect(i).Type = igDrawingView Then
            If (objSelect(i).DrawingViewType <> igDetailView) And (objSelect(i).DrawingViewType <> igNullView) Then
                'OK
            Else
                objSelect.Remove i
            End If
        Else
            objSelect.Remove i
        End If
    Next
    total = objSelect.count
    
    'Process each view in the select set.
    n = 0
    For k = 1 To total
        Set objdrv = objSelect(k)
        nModMem = 0
        nSubOcu = 0
        Erase ListaSubOcus()
        Erase listaModMem()
        n = n + 1
        
        lblVista.Caption = "Processing View " & n & " to " & total
        Err.Clear
        'Get the modellink
        Set ml = objdrv.ModelLink
        If Err Then
        'if err, It is not a drawing view from 3D
            Err.Clear
        Else
            On Error GoTo 0
            'I'm processing only drawing views from an ASM file. I ignore the rest of them.
            If LCase(Right(ml.FileName, 3)) = "asm" Then
                '--------------------------------------------------------
                'Get the ASM object
                Set objAsm = ml.ModelDocument
                '--------------------------------------------------------
                'Read occurrences and suboccurrences. Keep the information needed in a list: ListaSubOccus()
                lblPieza.Caption = "Processing SubOccurrences..."
                Me.Refresh
                readAllSubOccurrences objAsm
                '-------------------------------------------------------------
                'Same with modelmembers.
                lblPieza.Caption = "Processing ModelMembers..."
                Me.Refresh
                readAllModelMembers objdrv
                '-------------------------------------------------------------
                'Now to solve the original problem:
                'In my first tests i ended up supposing that the occurrences tree and modelmember tree
                'were similar. WRONG!!!
                'Now, for each modelmember i have to search its corresponding subOccurrence
                'The number of subOccurrences IS the same than the number of Modelmembers
                'I'm searching the corresponding pairs of modelmember-suboccurrence
                'by level of subassemblies.
                'In the same "path", if i find the same "name" and the occurrence is not "processed"
                'i consider both to be correspondant. I think this way i hit a 100% (i hope so!!!)
                '-----------------------------------------------------------------------------------
                For i = 1 To nModMem
                    'For each ModelMember...
                    For j = 1 To nSubOcu
                        'If the subOccurrence hasn't still been processed...
                        If Not ListaSubOcus(j).procesado Then
                            'I check that the ModelMember and SubOccurrence are contained in the same Subassembly
                            '(They have the same "path")
                            If LCase(listaModMem(i).path) = LCase(ListaSubOcus(j).path) Then
                                'Then, if the names are equal (it is the same part)
                                If LCase(listaModMem(i).nombre) = LCase(ListaSubOcus(j).nombre) Then
                                    'I consider them they are corresponding. So i copy the color from
                                    'the subOccurrence list to the Modelmembers list
                                    'and i mark the subOccurrence as "Processed" since there is a
                                    'one to one relation between suboccurrences and modelmembers
                                    ListaSubOcus(j).procesado = True
                                    listaModMem(i).color = ListaSubOcus(j).color
                                    Exit For
                                End If
                            End If
                        End If
                    Next j
                Next i
                
'------------debug---------------------------------
'Debug.Print nSubOcu & " = " & nModMem
'For i = 1 To nSubOcu
'    Debug.Print ListaSubOcus(i).path & "/" & _
'                ListaSubOcus(i).nombre & " , " & _
'                ListaSubOcus(i).color & " , " & _
'                ListaSubOcus(i).procesado & " , " & _
'                vbTab & vbTab & vbTab & vbTab & _
'                listaModMem(i).path & "/" & _
'                listaModMem(i).nombre & " , " & _
'                listaModMem(i).color
'Next i
'------------debug----------------------------------

                '-----------------------------------------------
                'Finally, i'm processing the modelmembers:
                'I create linear styles if needed (addstyles)
                'I set the styles for the modelmembers.
                '-----------------------------------------------
                pb.Min = 0
                pb.Max = nModMem
                pb.Value = 0
                For i = 1 To nModMem
                    pb.Value = pb.Value + 1
                    lblPieza.Caption = "Processing Part " & pb.Value & " to " & pb.Max
                    Me.Refresh
                    If listaModMem(i).color > -1 Then
                        addStyles CStr(listaModMem(i).color), listaModMem(i).color
                        matchStyle listaModMem(i).objeto, CStr(listaModMem(i).color)
                    End If
                Next i
            End If
        End If
        Set ml = Nothing
    Next k
    
    If Selected = False Then
        objDraft.SelectSet.RemoveAll
    End If
    
    objSE.DisplayAlerts = True
    objSE.DelayCompute = False
    'objSE.ActiveWindow.Fit
    'Refresh screen (F5)
    objSE.StartCommand (32876)
    my_end
End Sub

'------------------------------------------------------
'Add linear styles if they don't exist.
'objdraft is a global var.
'------------------------------------------------------
Sub addStyles(faceStyleName As String, color As Long)
Dim i As Integer
Dim objLStyles As LinearStyles, objLST As LinearStyle
On Error Resume Next

    'Visible
    Set objLStyles = objDraft.LinearStyles
    Err.Clear
    Set objLST = objLStyles(faceStyleName & "_visible")
    If Err Or objLST Is Nothing Then
        Err.Clear
        'Create the visible linearstyle from the default visible style.
        Set objLST = objLStyles.Add(faceStyleName & "_visible", visibleST)
        objLST.color = color
    End If
    
    'Hidden
    Err.Clear
    Set objLST = Nothing
    Set objLST = objLStyles(faceStyleName & "_hidden")
    If Err Or objLST Is Nothing Then
        'Create the hidden linearstyle from the default hidden style.
        Set objLST = objLStyles.Add(faceStyleName & "_hidden", hiddenST)
        objLST.color = color
    End If
    
    'Tangent
    Err.Clear
    Set objLST = Nothing
    Set objLST = objLStyles(faceStyleName & "_tangent")
    If Err Or objLST Is Nothing Then
        'Create the tangent linearstyle from the default tangent style.
        Set objLST = objLStyles.Add(faceStyleName & "_tangent", tangentST)
        objLST.color = color
    End If
    Set objLStyles = Nothing
    Set objLST = Nothing
    On Error GoTo 0
End Sub

'-----------------------------------------------------------------------
'Set styles for the modelmember.
'The names are the color number followed by: _visible, _hidden or _tangent
'-----------------------------------------------------------------------
Sub matchStyle(objmm As ModelMember, StyleName As String)
On Error Resume Next
        objmm.VisibleEdgeStyleName = StyleName & "_visible"
        objmm.HiddenEdgeStyleName = StyleName & "_hidden"
        objmm.TangentEdgeStyleName = StyleName & "_tangent"
On Error GoTo 0
End Sub

'-------------------------------
'End. Clean variables and finish
'-------------------------------
Sub my_end()
    On Error Resume Next   ' (if SE is closed)
    Erase ListaSubOcus(), listaModMem()
    Set objdrv = Nothing
    Set objAsm = Nothing
    Set objDraft = Nothing
    objSE.DisplayAlerts = True
    objSE.DelayCompute = False
    Set objSE = Nothing
    On Error GoTo 0
    End
End Sub

'--------------------------------------------------------------------------
'read the occurrences-suboccurrences in the ASM
'keep the filenames without path.
'keep the "path" inside the main ASM to get to the subOccurrence
'(e.g: if a part is inside the subAsm1.asm the path would be "/subAsm1.asm"
'Keep the color of the subOccurrence
'Mark the suboccurrence as not processed, later i reorder the suboccurrences.
'--------------------------------------------------------------------------
Sub readAllSubOccurrences(objAsm As SolidEdgeAssembly.AssemblyDocument)
Dim objOcu As SolidEdgeAssembly.Occurrence
Dim i As Integer, j As Integer, color As Long, count As Integer
Dim red As Long
Dim green As Long
Dim blue As Long
Dim temp As Long
Dim msg As String

Dim body As SolidEdgeGeometry.body
Dim facestyle As SolidEdgeFramework.facestyle




    'Read the occurrences at first level
    For i = 1 To objAsm.Occurrences.count
        Set objOcu = objAsm.Occurrences(i)
        'If the occurrence is a subassembly, get the suboccurrences
        If objOcu.Subassembly Then
            On Error Resume Next
            count = objOcu.SubOccurrences.count
            If Err Then     'sub assembly file is missing
                Err.Clear
                On Error GoTo 0
            Else
                On Error GoTo 0
                For j = 1 To objOcu.SubOccurrences.count
                    readSubOccurrences objOcu.SubOccurrences(j), "/" & nombrefich(objOcu.OccurrenceFileName)
                Next j
            End If
        Else
        'The occurrence is a part, get the assembly facestyle if exists
            If Not objOcu.facestyle Is Nothing Then
                With objOcu.facestyle
                    color = RGB(CInt(255 * .DiffuseRed), CInt(255 * .DiffuseGreen), CInt(255 * .DiffuseBlue))
                End With

            Else
            
                'The part body has a facestyle. Get color from the body if exists
                Set body = objOcu.OccurrenceDocument.Models(1).body
                Set facestyle = body.Style
                
                If facestyle Is Nothing Then
                
                  'If not, color is set to -1
                  color = -1
                  
                Else

                  'use the part body facestyle
                  color = RGB(CInt(255 * facestyle.DiffuseRed), _
                    CInt(255 * facestyle.DiffuseGreen), _
                    CInt(255 * facestyle.DiffuseBlue))
  
                End If
            End If
            'Add the occurrence to the list.
            nSubOcu = nSubOcu + 1
            ReDim Preserve ListaSubOcus(1 To nSubOcu)
            ListaSubOcus(nSubOcu).nombre = nombrefich(objOcu.OccurrenceFileName)
            ListaSubOcus(nSubOcu).path = ""
            ListaSubOcus(nSubOcu).color = color
            ListaSubOcus(nSubOcu).procesado = False
        End If
    Next i
    Set objOcu = Nothing
End Sub

'--------------------------------------------------------------------------
'read the suboccurrences in a suboccurrence
'This sub is called recursively.
'keep the filenames without path.
'keep the "path" inside the main ASM to get to the subOccurrence
'(e.g: if a part is inside the subAsm1.asm then in "SubAsm2.asm" the path would be "/subAsm1.asm/SubAsm2.asm"
'Keep the color of the subOccurrence
'Mark the suboccurrence as not processed, later i reorder the suboccurrences.
'--------------------------------------------------------------------------
Sub readSubOccurrences(subOcu As SubOccurrence, path As String)
Dim i As Integer, count As Integer
Dim dc(1 To 3) As Double
Dim ac(1 To 3) As Double
Dim sc(1 To 3) As Double
Dim ec(1 To 3) As Double
Dim sh As Double
Dim op As Double

    RecCount = RecCount + 1
    If RecCount = 10 Then
        RecCount = 0
        lblPieza.Caption = lblPieza.Caption + "."
        Me.Refresh
        If Len(lblPieza.Caption) > 110 Then
            lblPieza.Caption = "Processing SubOccurrences."
        End If
    End If
    If subOcu.Subassembly Then      'this is a sub assembly:
        On Error Resume Next
        count = subOcu.SubOccurrences.count
        If Err Then     'sub assembly file is missing
            Err.Clear
            On Error GoTo 0
        Else
            On Error GoTo 0
            For i = 1 To subOcu.SubOccurrences.count
                readSubOccurrences subOcu.SubOccurrences(i), path & "/" & nombrefich(subOcu.SubOccurrenceFileName)
            Next i
        End If
    Else        'this is a part:
        nSubOcu = nSubOcu + 1
        ReDim Preserve ListaSubOcus(1 To nSubOcu)
        ListaSubOcus(nSubOcu).nombre = nombrefich(subOcu.SubOccurrenceFileName) 'Generates filename without path.
        ListaSubOcus(nSubOcu).path = path 'Path inside the ASM
        'Get the color
        subOcu.GetMaterial dc(), ac(), sc(), ec(), sh, op
        ListaSubOcus(nSubOcu).color = RGB(CInt(255 * dc(1)), CInt(255 * dc(2)), CInt(255 * dc(3)))
        ListaSubOcus(nSubOcu).procesado = False
    End If
End Sub

'--------------------------------------------------------------------------
'read the modelmembers in a drawing view
'keep the filenames without path.
'keep the "path" inside the main Modelmember to get to the actual Modelmember
'(e.g: if a part is inside the subAsm1.asm then in "SubAsm2.asm" the path would be "/subAsm1.asm/SubAsm2.asm"
'Keep the color as -1 (not assigned yet)
'Keep the modelmember object to assign color later on.
'--------------------------------------------------------------------------
Sub readAllModelMembers(objdrv As DrawingView)
Dim i As Integer
Dim objModMember As ModelMember
    Set objModMember = objdrv.ModelMembers(1)
    For i = 1 To objModMember.ModelMembers.count
        readModelMembers objModMember.ModelMembers(i), ""
    Next i
End Sub

'--------------------------------------------------------------------------
'read the modelmembers in a modelmember
'This sub is called recursively
'keep the filenames without path.
'keep the "path" inside the main Modelmember to get to the actual Modelmember
'(e.g: if a part is inside the subAsm1.asm then in "SubAsm2.asm" the path would be "/subAsm1.asm/SubAsm2.asm"
'Keep the color as -1 (not assigned yet)
'Keep the modelmember object to assign color later on.
'I also use this sub to get the original linear styles in a view.
'--------------------------------------------------------------------------
Sub readModelMembers(objmm As ModelMember, path As String)
Dim i As Integer

    RecCount = RecCount + 1
    If RecCount = 10 Then
        RecCount = 0
        lblPieza.Caption = lblPieza.Caption + "."
        Me.Refresh
        If Len(lblPieza.Caption) > 110 Then
            lblPieza.Caption = "Processing ModelMembers."
        End If
    End If

    On Error Resume Next
    If objmm.ModelMembers.count > 0 Then
        'If a subassembly (count>0) call recursively.
        For i = 1 To objmm.ModelMembers.count
            readModelMembers objmm.ModelMembers(i), path & "/" & objmm.FileName
        Next i
    Else
        'It is a part, not a subassembly.
        If Not found Then
            'I Get the original stylenames from the first modelmember not displayed as "Reference"
            'I store the names in these variables.
            'I will create new linear styles with these as parents.
            If Not objmm.DisplayAsReference Then
                visibleST = objmm.VisibleEdgeStyleName
                hiddenST = objmm.HiddenEdgeStyleName
                tangentST = objmm.TangentEdgeStyleName
                found = True 'I get the styles only once!!!
            End If
        End If
        'Now add the modelmember to the list.
        nModMem = nModMem + 1
        ReDim Preserve listaModMem(1 To nModMem)
        listaModMem(nModMem).nombre = objmm.FileName
        listaModMem(nModMem).path = path
        Set listaModMem(nModMem).objeto = objmm
        listaModMem(nModMem).color = -1
    End If
    On Error GoTo 0
End Sub


