#Python Script zum Transformieren von Dateinamen im Desktop-Ordner "Alt" für Gross-/Kleinschreibung"

import os
import ctypes

PATH = r"C:\Users\xxxxx\Desktop\Alt"

if not os.path.isdir(PATH):
    ctypes.windll.user32.MessageBoxW(0, 'Ordner "Alt" existiert nicht', 'Error', 48)
    exit()

fileList = [
    f for f in os.listdir(PATH)
    if f.lower().endswith(".pdf")
]
total = len(fileList)
count = 0

def process(root):
    chars = []
    token = ''

    for char in root:
        if char.isalnum() or char in "äöüÄÖÜß":
            token += char

        else:
            if token:
                chars.append(token.capitalize())
                token = ''
            chars.append(char)

    if token:
        chars.append(token.lower())
        
    return ''.join(chars)

# Apply transformation
for file in fileList:
    print(file)
    oldPath = os.path.join(PATH, file)
    root, ext = os.path.splitext(file)

    newFile = process(root) + ext

    if file != newFile:
        newPath = os.path.join(PATH, newFile)
        os.rename(oldPath, newPath)
        count += 1
        print(newFile)
    else:
        print("-")
    print()

print(f"{count} von {total} Dateien umbenannt")
os.system("pause")
